<?php
/* --------------------------------------------------------------
 EventDispatcherServiceProvider.php 2020-04-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Event;

use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Logging\LoggerBuilder;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class EventDispatcherServiceProvider
 *
 * @package Gambio\Core\Event
 */
class EventDispatcherServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            EventListenerProvider::class,
            EventDispatcherInterface::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(EventListenerProvider::class)->addArgument($this->application);
        $this->application->share(EventDispatcherInterface::class,
            function () {
                /** @var LoggerBuilder $loggerBuilder */
                $loggerBuilder = $this->application->get(LoggerBuilder::class);
                $dispatcher    = new EventDispatcher($loggerBuilder->changeNamespace('event_handlers')->build());
                $dispatcher->registerProvider($this->application->get(EventListenerProvider::class));
                
                return $dispatcher;
            });
    }
}